interface NotificationBadgeProps {
  count: number;
}

export function NotificationBadge({ count }: NotificationBadgeProps) {
  if (count === 0) return null;

  return (
    <div className="absolute -top-1 -right-1 h-5 w-5 rounded-full bg-primary flex items-center justify-center">
      <span className="text-xs font-semibold text-primary-foreground">
        {count > 9 ? "9+" : count}
      </span>
    </div>
  );
}
