import { Button } from "@/components/ui/button";
import { Card } from "@/components/ui/card";
import { Sparkles, ArrowRight } from "lucide-react";
import { SiGoogle, SiGithub } from "react-icons/si";
import { login } from "@/hooks/use-auth";

export default function Login() {
  return (
    <div className="min-h-screen bg-background relative overflow-hidden flex items-center justify-center p-4">
      {/* Animated gradient background */}
      <div className="absolute inset-0 bg-gradient-to-br from-indigo-500/10 via-purple-500/10 to-teal-400/10 animate-gradient-xy" />
      
      {/* Floating gradient orbs for effect */}
      <div className="absolute top-20 left-10 w-72 h-72 bg-purple-500/20 rounded-full blur-3xl animate-pulse" />
      <div className="absolute bottom-20 right-10 w-96 h-96 bg-cyan-500/20 rounded-full blur-3xl animate-pulse delay-1000" />
      
      <div className="w-full max-w-md relative z-10">
        {/* Logo & Title */}
        <div className="text-center space-y-4 mb-8">
          <div className="inline-flex items-center justify-center gap-2 mb-2">
            <div className="h-12 w-12 rounded-xl bg-gradient-to-br from-indigo-500 to-purple-600 flex items-center justify-center shadow-lg shadow-purple-500/30">
              <Sparkles className="h-7 w-7 text-white" />
            </div>
          </div>
          <h1 className="text-4xl font-bold bg-gradient-to-r from-indigo-400 via-purple-400 to-teal-400 bg-clip-text text-transparent">
            Welcome to PlanMate AI
          </h1>
          <p className="text-muted-foreground text-lg">
            Your intelligent planning companion
          </p>
        </div>

        {/* Glass morphic login card */}
        <Card className="p-8 bg-card/50 backdrop-blur-xl border-white/10 shadow-2xl shadow-purple-500/10">
          <div className="space-y-6">
            <div className="text-center space-y-2">
              <h2 className="text-2xl font-semibold">Sign in to continue</h2>
              <p className="text-sm text-muted-foreground">
                Connect with your Replit account to get started
              </p>
            </div>

            {/* Login button */}
            <Button
              className="w-full bg-gradient-to-r from-indigo-500 to-purple-600 h-12 text-base shadow-lg shadow-purple-500/20"
              onClick={login}
              data-testid="button-login-replit"
            >
              <Sparkles className="mr-2 h-5 w-5" />
              Login with Replit
              <ArrowRight className="ml-2 h-5 w-5" />
            </Button>

            {/* Divider */}
            <div className="relative">
              <div className="absolute inset-0 flex items-center">
                <div className="w-full border-t border-white/10" />
              </div>
              <div className="relative flex justify-center text-xs uppercase">
                <span className="bg-card px-2 text-muted-foreground">
                  Authentication Options
                </span>
              </div>
            </div>

            {/* Info cards */}
            <div className="grid grid-cols-2 gap-3">
              <div className="flex items-center gap-2 p-3 rounded-lg bg-white/5 border border-white/10">
                <SiGoogle className="h-4 w-4 text-muted-foreground" />
                <span className="text-xs text-muted-foreground">Google</span>
              </div>
              <div className="flex items-center gap-2 p-3 rounded-lg bg-white/5 border border-white/10">
                <SiGithub className="h-4 w-4 text-muted-foreground" />
                <span className="text-xs text-muted-foreground">GitHub</span>
              </div>
            </div>

            {/* Features list */}
            <div className="pt-4 space-y-2 border-t border-white/10">
              <p className="text-xs text-muted-foreground text-center mb-3">
                What you'll get:
              </p>
              <div className="grid gap-2 text-sm">
                <div className="flex items-center gap-2 text-muted-foreground">
                  <div className="h-1.5 w-1.5 rounded-full bg-gradient-to-r from-indigo-400 to-purple-400" />
                  <span>AI-powered task suggestions</span>
                </div>
                <div className="flex items-center gap-2 text-muted-foreground">
                  <div className="h-1.5 w-1.5 rounded-full bg-gradient-to-r from-purple-400 to-pink-400" />
                  <span>Smart progress tracking</span>
                </div>
                <div className="flex items-center gap-2 text-muted-foreground">
                  <div className="h-1.5 w-1.5 rounded-full bg-gradient-to-r from-cyan-400 to-teal-400" />
                  <span>Cloud synchronization</span>
                </div>
              </div>
            </div>
          </div>
        </Card>

        {/* Footer text */}
        <p className="text-center text-xs text-muted-foreground mt-6">
          By continuing, you agree to our{" "}
          <a href="#" className="text-primary hover:underline" data-testid="link-terms">
            Terms of Service
          </a>{" "}
          and{" "}
          <a href="#" className="text-primary hover:underline" data-testid="link-privacy">
            Privacy Policy
          </a>
        </p>
      </div>
    </div>
  );
}
